
//
// To jest przykadowy kod z podrozdziau 25.3.3 Przykad zastosowania puli" ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

//------------------------------------------------------------------------------

template<class T, int N> 
class Pool                 // Pula N obiektw typu T.
{
public:
    Pool();                // Tworzy pul n obiektw typu T.
    T* get();              // Pobiera element T z puli. Zwraca warto 0, jeli nie ma wolnych T.
    void free(T*);         // Zwraca do puli T wydany przez funkcj get().
    int available() const; // Liczba wolnych T.
private:
    // Przestrze dla T[N] i danych do ledzenia, ktre T s alokowane,
    // a ktre nie (np. lista wolnych obiektw).
};

//------------------------------------------------------------------------------

class Small_buffer;
class Status_indicator;

//------------------------------------------------------------------------------

int main()
{
    Pool<Small_buffer,10> sb_pool;
    Pool<Status_indicator,200> indicator_pool;

    Small_buffer* p = sb_pool.get();
    // ...
    sb_pool.free(p);
}

//------------------------------------------------------------------------------
